set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1220403',
      1,
      0,
      9.402049,
      0.594614,
      3,
      2.927645,
      16.816041,
      NULL,
      1,
      0,
      1,
      3,
      2,
      1,
      0,
      0,
      1,
      1.550486,
      0.213955,
      0.506298,
      1.835268,
      2,
      0.555890,
      NULL,
      1,
      1.731045,
      NULL,
      NULL,
      1.692179,
      NULL,
      1.937564,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.860155,
      3,
      2.560908,
      3.560492,
      NULL,
      3,
      0.850922,
      1,
      0,
      0.736725,
      1,
      0,
      1,
      NULL,
      1,
      0.630408,
      1.667322,
      0,
      0.684033,
      NULL,
      1,
      1,
      NULL,
      0,
      1.201315,
      1,
      1.368879,
      3,
      0,
      3,
      0,
      1,
      0.104585,
      0.444118,
      2.132095,
      2.083800,
      NULL,
      2,
      1.927895,
      0,
      0,
      NULL,
      1,
      1.741857,
      1,
      NULL,
      NULL,
      0.137874,
      1,
      1,
      0.720938,
      0.526420,
      1,
      2,
      3.539917,
      NULL,
      0.116105,
      0,
      1,
      2.546733,
      NULL,
      3,
      1.724573,
      2,
      1.587081,
      NULL,
      10,
      4.869714,
      '',
      NULL,
      '11-11-2002');
commit;
end;
/


