set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8809876';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3223224',
      2.841782,
      0,
      30,
      1.458820,
      1.999954,
      4.477873,
      NULL,
      14.076326,
      0.338107,
      0,
      NULL,
      3,
      0.526596,
      0,
      NULL,
      0.825545,
      0,
      0,
      NULL,
      1,
      1,
      3.614698,
      0,
      1.424693,
      0.497971,
      NULL,
      0.935511,
      NULL,
      0,
      NULL,
      0.030094,
      2,
      1.233037,
      0,
      1.345224,
      NULL,
      1,
      1.844631,
      1.323997,
      2,
      0.664323,
      1.774836,
      3,
      NULL,
      0,
      2,
      0.539813,
      1.857811,
      1.434065,
      NULL,
      NULL,
      0.358157,
      1.642976,
      0,
      1.794326,
      0.330748,
      NULL,
      1.700231,
      0,
      1.436283,
      1,
      1,
      1.436976,
      0,
      1.740137,
      0.805795,
      NULL,
      2.735220,
      NULL,
      0,
      1,
      2,
      0,
      0.170022,
      1.832718,
      0.293379,
      1.644043,
      3,
      1,
      1,
      0.281917,
      0,
      NULL,
      1.306656,
      0,
      3.755167,
      NULL,
      1.736117,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      1.642331,
      NULL,
      NULL,
      2.398025,
      3,
      1.895061,
      NULL,
      3,
      '',
      NULL,
      ' 4-15-1993');
commit;
end;
/


