set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2433132',
      2,
      NULL,
      5.629198,
      1,
      0,
      NULL,
      NULL,
      1.333404,
      0.224696,
      0.655411,
      0,
      3,
      3,
      1,
      0.196713,
      1.741359,
      1.248938,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      0.501393,
      1,
      1,
      1,
      2,
      0.497982,
      NULL,
      1.156676,
      0,
      NULL,
      2,
      NULL,
      0,
      1.826025,
      2,
      1.300826,
      0,
      2,
      NULL,
      0,
      1.699400,
      0.418547,
      2.640971,
      1,
      0.666941,
      NULL,
      NULL,
      0.149337,
      0.413130,
      0,
      NULL,
      0,
      1,
      3,
      0,
      1,
      0,
      NULL,
      2.273295,
      0,
      2,
      0.422105,
      0,
      0,
      1,
      0.915720,
      NULL,
      3,
      3,
      1.364646,
      0,
      NULL,
      1.474856,
      0,
      0,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0.863111,
      3.499690,
      1,
      1.955852,
      NULL,
      NULL,
      1.185725,
      3,
      1.984039,
      0.679522,
      3.602896,
      0.098542,
      1,
      35,
      4,
      '',
      '',
      ' 0-29-1982');
commit;
end;
/


