set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8801750';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2434302',
      NULL,
      2,
      8.582647,
      5,
      1,
      NULL,
      NULL,
      45.796961,
      1.369590,
      1.970579,
      NULL,
      2,
      1,
      0,
      0,
      3,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      3,
      0,
      1.860677,
      1.140438,
      1.134859,
      0.755227,
      3.519155,
      0.982085,
      3,
      1.369460,
      NULL,
      1,
      1,
      1,
      NULL,
      1.083649,
      0,
      2,
      1.091168,
      NULL,
      2,
      0.528644,
      2.837136,
      1.371500,
      2.198136,
      1.284565,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.803686,
      0,
      0.176372,
      0.683658,
      2.452361,
      NULL,
      NULL,
      1,
      1.365746,
      1,
      0,
      1.896648,
      1.041552,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.930590,
      1,
      1,
      NULL,
      1.389661,
      0,
      0.527916,
      0.300609,
      0,
      0.609772,
      0.113152,
      0,
      1,
      1.331801,
      1,
      0.512842,
      0.810359,
      1,
      NULL,
      1,
      0.443527,
      0,
      0,
      1,
      NULL,
      2,
      1.241170,
      2,
      0.241356,
      7,
      NULL,
      '130',
      NULL,
      ' 1-29-1977');
commit;
end;
/


