set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7938212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1043112',
      1,
      2,
      NULL,
      2,
      2.248896,
      NULL,
      9.246259,
      35,
      0,
      1,
      NULL,
      2.936457,
      1,
      NULL,
      NULL,
      1.653779,
      3.681910,
      0.209950,
      3.824844,
      2.847368,
      NULL,
      NULL,
      NULL,
      0.674075,
      NULL,
      2,
      1,
      0.912205,
      1,
      3,
      1,
      2.593896,
      1.927409,
      1,
      0,
      1.690935,
      NULL,
      1.907746,
      0,
      1,
      1,
      NULL,
      0.708170,
      0.920513,
      0.248980,
      0.950231,
      1,
      1.075850,
      1.236053,
      2,
      0.308436,
      0.572267,
      0,
      1.920476,
      1,
      0.496210,
      0.799967,
      0,
      1,
      2.142908,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.954763,
      NULL,
      NULL,
      1.198996,
      0.657664,
      0,
      1.878080,
      0,
      1.262990,
      0.588609,
      1.852995,
      1,
      0,
      1,
      1.008145,
      1.756675,
      1.453169,
      0.101901,
      NULL,
      0.558762,
      1.598619,
      2.689018,
      NULL,
      0,
      1,
      1.723636,
      3,
      NULL,
      0,
      0.126287,
      1.188619,
      1.836274,
      0.580293,
      0,
      2.361111,
      NULL,
      0.899088,
      0.544268,
      14,
      0,
      '',
      '',
      '10-12-1976');
commit;
end;
/


