set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3304043',
      NULL,
      NULL,
      18.399300,
      3,
      1,
      4.582286,
      2.802045,
      43.987693,
      1.520830,
      0,
      0.306545,
      0,
      2,
      1,
      1,
      NULL,
      0,
      0.664594,
      0,
      0.667014,
      NULL,
      1.142618,
      0.439621,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.979004,
      0,
      NULL,
      0.072062,
      1.101217,
      0,
      1,
      3,
      1,
      1,
      0,
      0,
      1.762820,
      2,
      0.745834,
      NULL,
      0.244877,
      0.504887,
      0,
      0.371307,
      0,
      2.454706,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.657366,
      NULL,
      3.247373,
      1.905116,
      0,
      1,
      NULL,
      2,
      0.927584,
      1,
      1,
      0,
      0.193364,
      NULL,
      0,
      0.816764,
      2.547304,
      0.236222,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      1,
      0,
      1.070141,
      0,
      0,
      3.254097,
      0.560212,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      1.977203,
      0,
      1.315717,
      3,
      0,
      2.746668,
      NULL,
      1.873586,
      NULL,
      NULL,
      0.528485,
      NULL,
      3,
      '',
      '',
      ' 9-29-2002');
commit;
end;
/


