set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3441204',
      0,
      2,
      26.699173,
      3.170020,
      NULL,
      NULL,
      NULL,
      115.966393,
      0.634596,
      NULL,
      1.960279,
      NULL,
      0.358002,
      1,
      3.786515,
      1.701493,
      1,
      3,
      1.296996,
      NULL,
      1,
      3.137724,
      1.068799,
      2,
      0.201026,
      2,
      1,
      0,
      1.728773,
      NULL,
      1.388552,
      1,
      1,
      NULL,
      0.389665,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      3.716535,
      1,
      1.533582,
      1.635206,
      1,
      2.032539,
      1,
      1,
      1.095787,
      1,
      1.798436,
      1.644081,
      0,
      0.372028,
      0.211945,
      NULL,
      2.207261,
      2,
      1,
      1,
      1.715831,
      0,
      3.774569,
      1,
      2,
      0,
      1.329097,
      NULL,
      1.560738,
      1.741834,
      0,
      NULL,
      2,
      0.185629,
      0.045779,
      1.750011,
      NULL,
      0,
      0,
      1,
      1.103156,
      NULL,
      3.281653,
      1,
      0,
      NULL,
      1.370220,
      NULL,
      0.793719,
      1.773125,
      NULL,
      0,
      3.818719,
      1.933626,
      1,
      1.914282,
      0.741389,
      3.947975,
      NULL,
      1.738093,
      NULL,
      0,
      NULL,
      3.171237,
      11.047390,
      '',
      '',
      ' 2-17-1998');
commit;
end;
/


