set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6711972';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2,
      NULL,
      0.401207,
      2,
      5,
      5,
      50.206149,
      2,
      1,
      1,
      0.587881,
      0.711622,
      0.653877,
      3.130954,
      1,
      0.692646,
      0.956677,
      1.958115,
      NULL,
      1,
      0,
      0,
      3.807503,
      0.655657,
      3,
      1.485560,
      1,
      NULL,
      0,
      0.644322,
      1,
      1.111220,
      0,
      1.888956,
      2,
      0.467035,
      1,
      1.795925,
      2.445028,
      0.021281,
      0,
      0,
      NULL,
      1.222851,
      3,
      0.501710,
      1.360112,
      0.894434,
      2.961728,
      1,
      1.229004,
      1,
      NULL,
      NULL,
      1,
      0.438896,
      1.825276,
      1.813067,
      0.061753,
      1,
      0,
      0,
      0.691134,
      NULL,
      3.271763,
      1.749781,
      3,
      0,
      0.877123,
      0.313275,
      1.050205,
      2.672538,
      0,
      NULL,
      0.285994,
      0.271625,
      0,
      NULL,
      1,
      NULL,
      0,
      0.266884,
      0,
      NULL,
      2,
      1,
      NULL,
      3.847870,
      NULL,
      0,
      0.380488,
      3.771361,
      NULL,
      1.114038,
      0,
      1,
      0.390224,
      3.630928,
      3.503385,
      0.635908,
      NULL,
      NULL,
      1,
      20,
      2.859215,
      '',
      '',
      NULL);
commit;
end;
/


