set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132060';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4211042',
      1.730684,
      2,
      15,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.988489,
      1,
      0,
      0,
      3.962318,
      1.125972,
      0.703457,
      NULL,
      1.918853,
      1,
      0,
      0,
      NULL,
      3.933659,
      0.653216,
      1.195810,
      NULL,
      2,
      0,
      2.383198,
      0.442177,
      1.084311,
      1.131192,
      0.549980,
      1,
      0,
      1,
      0.064933,
      NULL,
      0.498734,
      1.811269,
      1,
      0.950404,
      NULL,
      3.010131,
      3,
      1.074799,
      NULL,
      1.850517,
      3,
      NULL,
      0,
      1,
      0.614787,
      1,
      1.854957,
      NULL,
      1.625730,
      0.277913,
      0.709843,
      2,
      1.908423,
      0,
      0.514033,
      0.365108,
      1,
      1.671729,
      NULL,
      0.100338,
      1.751308,
      0,
      1,
      0.556690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.846856,
      0.077872,
      0.881103,
      1.273793,
      NULL,
      1,
      1,
      0,
      1.792835,
      1.188850,
      1,
      1.767246,
      1.864615,
      0,
      1,
      1.218115,
      1.245737,
      3,
      1.882971,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.172632,
      NULL,
      7.330214,
      NULL,
      '413',
      NULL,
      ' 9-23-1988');
commit;
end;
/


