set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8010848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0214444',
      1.531714,
      NULL,
      3.667374,
      3,
      NULL,
      NULL,
      4,
      18.199895,
      1.984163,
      NULL,
      0,
      0.394948,
      0.436961,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.432136,
      0.031500,
      NULL,
      1,
      0,
      NULL,
      1.496082,
      NULL,
      1.339205,
      NULL,
      0.237950,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      3,
      3.079280,
      1,
      2,
      1.437694,
      1.459786,
      0,
      1.994539,
      1.751292,
      NULL,
      0.136016,
      1,
      0.156441,
      0.417827,
      1,
      0,
      0,
      NULL,
      3,
      2.618210,
      1.589684,
      1.344185,
      0,
      1,
      1.131060,
      1.052140,
      1.776922,
      3.627973,
      1.142920,
      1.189266,
      0,
      1.603895,
      1.976387,
      NULL,
      1.880892,
      0,
      0,
      NULL,
      0.193386,
      1.122890,
      1,
      1.777121,
      0,
      NULL,
      NULL,
      0.702192,
      1,
      0.104919,
      1.178619,
      NULL,
      1,
      3,
      2,
      NULL,
      1.183345,
      0,
      0.722372,
      0.806772,
      3,
      3.033863,
      3.531809,
      3,
      NULL,
      NULL,
      2.423444,
      NULL,
      '',
      '',
      ' 4- 8-1988');
commit;
end;
/


