set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5905417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4401214',
      3.793023,
      3,
      8.239960,
      2.074120,
      1,
      2.385149,
      25,
      48.773557,
      0,
      1.976901,
      1.329175,
      0,
      0.057424,
      NULL,
      0.369119,
      2,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.795903,
      2,
      0,
      0.470794,
      0.591489,
      0,
      0,
      1.656749,
      1.335097,
      1.563136,
      1.987800,
      0.578718,
      NULL,
      1,
      NULL,
      1.958055,
      1.974119,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      0.596954,
      0.189730,
      1.871561,
      0,
      0.774775,
      1,
      1.923088,
      3.627071,
      0,
      1,
      1,
      1.811851,
      0,
      2.594807,
      0.350625,
      1.758457,
      0.234865,
      1,
      1.789115,
      3.032557,
      1.158249,
      3,
      NULL,
      1,
      1,
      NULL,
      2.663887,
      1,
      0.482607,
      0.157544,
      NULL,
      0,
      0,
      1.117169,
      0,
      0.612548,
      1,
      1.204260,
      1,
      1.068924,
      0,
      0.083371,
      0.543679,
      0,
      1.297246,
      3.104550,
      0.947889,
      NULL,
      0,
      1.577629,
      NULL,
      0,
      0.639637,
      0.506922,
      1,
      NULL,
      0,
      NULL,
      0.804981,
      2,
      '',
      '',
      NULL);
commit;
end;
/


