set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220725';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3414304',
      NULL,
      1,
      NULL,
      3,
      1.050201,
      NULL,
      NULL,
      NULL,
      0,
      1.754377,
      3.857133,
      0.412327,
      3.491099,
      0,
      2.760597,
      1.829024,
      0.005606,
      1.283068,
      0.607318,
      1,
      0,
      1,
      0.490352,
      0.491315,
      0.033841,
      2,
      0,
      1.147133,
      NULL,
      2,
      1.071801,
      0.631330,
      0,
      NULL,
      0,
      3.613351,
      0,
      1,
      0,
      3,
      3.982438,
      2.600138,
      3.690318,
      0,
      1.572405,
      3.089518,
      1,
      0,
      0.355979,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.957722,
      0.100822,
      NULL,
      0.503560,
      1.553904,
      1,
      1,
      0.901465,
      1,
      1.780201,
      0.162503,
      1,
      1,
      1.852171,
      0.690934,
      NULL,
      0,
      3.257717,
      2.752589,
      NULL,
      3,
      0,
      0,
      1.496211,
      0.050568,
      0,
      0.559751,
      1,
      1.085030,
      0,
      0,
      1.166992,
      1,
      0,
      NULL,
      0.233277,
      NULL,
      2.787381,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.423398,
      0,
      1,
      2.253430,
      NULL,
      1,
      9.630697,
      1.731133,
      NULL,
      '220',
      NULL);
commit;
end;
/


