set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7718730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2120014',
      1.600513,
      3,
      2,
      NULL,
      1.860424,
      NULL,
      NULL,
      78.733428,
      0.692035,
      0,
      1.092996,
      NULL,
      0.686818,
      1.117736,
      1.415618,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1.689175,
      1,
      0.282893,
      1,
      NULL,
      NULL,
      1,
      1.482526,
      1.515481,
      1,
      1,
      0.541820,
      0.507171,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      3.977906,
      1,
      2.922239,
      NULL,
      2,
      0.310370,
      0.382888,
      0.024780,
      1,
      1,
      1,
      1,
      2.526250,
      0.793399,
      1.184787,
      0.768312,
      1.839990,
      NULL,
      1.182848,
      0.878209,
      0.686684,
      NULL,
      1,
      0.744084,
      NULL,
      1,
      0,
      0,
      0.110152,
      NULL,
      1.447017,
      1,
      NULL,
      0,
      3.762897,
      1,
      NULL,
      0,
      0,
      NULL,
      1.262603,
      NULL,
      0.156850,
      1,
      NULL,
      3.191967,
      3,
      0,
      3,
      2,
      0.798859,
      NULL,
      NULL,
      1.256454,
      1,
      0.851227,
      NULL,
      0,
      1.941599,
      1,
      1.192445,
      0.248551,
      0.224954,
      20.508247,
      20.883104,
      NULL,
      '',
      ' 8- 4-1988');
commit;
end;
/


