set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7727700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      0,
      NULL,
      1.686718,
      2.513538,
      2.773432,
      62.315953,
      76,
      1,
      2.152649,
      1.995202,
      1.050505,
      1,
      1,
      0.060799,
      1.200328,
      0,
      0.906285,
      0,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0.347793,
      1.834631,
      1,
      2.344021,
      1.393402,
      NULL,
      NULL,
      0,
      0.990998,
      NULL,
      0.736549,
      2,
      1.433607,
      2,
      3.202438,
      0,
      1,
      NULL,
      1,
      3.942960,
      1,
      NULL,
      1,
      NULL,
      0.644405,
      1.487251,
      0.376801,
      NULL,
      NULL,
      2.839395,
      1.444186,
      1,
      0.460072,
      2.493072,
      1,
      1.478565,
      0.040449,
      NULL,
      0.476426,
      1,
      NULL,
      0,
      0.548042,
      0,
      1,
      2,
      NULL,
      0.587437,
      1.172759,
      3.235052,
      NULL,
      0,
      1.604187,
      1,
      1,
      3.262119,
      0.881303,
      0.442424,
      0.063718,
      NULL,
      NULL,
      1,
      0.077595,
      0.778249,
      1,
      1,
      3.844142,
      1.680156,
      2.197094,
      NULL,
      2.234343,
      2,
      2.603036,
      1.588204,
      1,
      NULL,
      NULL,
      1,
      46.652110,
      13.793980,
      NULL,
      '',
      ' 7- 2-1985');
commit;
end;
/


