set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9335168';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4123441',
      1,
      0,
      11.733539,
      2,
      0,
      NULL,
      NULL,
      32,
      1.910592,
      3.933116,
      1,
      3,
      1,
      1.092516,
      0.827584,
      NULL,
      0,
      0.215769,
      3,
      1,
      NULL,
      0.958563,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.316058,
      1.675318,
      1,
      NULL,
      0,
      0,
      0,
      1.321586,
      0.844396,
      0.838425,
      NULL,
      2,
      0.722817,
      1,
      3.155401,
      1.722568,
      0,
      1.688583,
      NULL,
      0.403461,
      2,
      0,
      0,
      NULL,
      1.450049,
      1.283908,
      1.318484,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.563521,
      0.979312,
      0,
      3,
      1.014652,
      1.876422,
      0,
      1.745556,
      0.202792,
      2.840786,
      1.889636,
      1.302666,
      1.853508,
      0.352596,
      1.816170,
      NULL,
      1,
      1,
      0,
      1.216285,
      NULL,
      NULL,
      0,
      1,
      0.370353,
      0.070297,
      NULL,
      1,
      1.944922,
      0,
      0.547259,
      1.619700,
      0.459252,
      3.845083,
      0,
      3,
      0.848211,
      NULL,
      2.143590,
      1,
      3,
      2,
      '111',
      '03',
      ' 3- 7-1997');
commit;
end;
/


