set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2042242',
      2,
      0,
      NULL,
      2.908028,
      0,
      2.219335,
      NULL,
      105,
      0,
      1,
      0.135317,
      1,
      2.917282,
      NULL,
      NULL,
      2.081537,
      0.487688,
      0.658213,
      2.337747,
      NULL,
      0.098523,
      3.637289,
      NULL,
      3.283340,
      0,
      NULL,
      0.688279,
      3.419749,
      0,
      1.049321,
      NULL,
      NULL,
      0,
      0.568157,
      NULL,
      NULL,
      0,
      1.061919,
      0.741662,
      0.990883,
      2,
      0.695060,
      3,
      0,
      0.212918,
      1.856744,
      NULL,
      0,
      0.025042,
      0.331975,
      0.956120,
      0,
      1.883471,
      3.768997,
      1.303338,
      NULL,
      1,
      1,
      NULL,
      1.891049,
      0.330244,
      0,
      0,
      0.699077,
      NULL,
      0.690037,
      1,
      3,
      0.032477,
      1.298478,
      1,
      0,
      NULL,
      1.097152,
      NULL,
      1.386574,
      0.412241,
      2.438832,
      NULL,
      0.295556,
      1.938758,
      NULL,
      NULL,
      1.479421,
      0.169308,
      1,
      1,
      1,
      1,
      1.965082,
      1.236266,
      2,
      0,
      NULL,
      3.984748,
      0.704999,
      1,
      NULL,
      NULL,
      0,
      1.794309,
      3.813050,
      0.972724,
      0.101221,
      25.328445,
      3.909500,
      '124',
      '440',
      ' 8-18-1978');
commit;
end;
/


