set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9302867';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4422144',
      NULL,
      3,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      25.769431,
      0.030758,
      3.089911,
      0,
      2,
      3,
      NULL,
      3.050073,
      2.901566,
      NULL,
      0,
      1,
      1.382253,
      NULL,
      0.369077,
      1.549924,
      NULL,
      0.518569,
      0,
      NULL,
      1,
      1.004322,
      2.966204,
      1,
      0,
      1.757359,
      1,
      1,
      0.737379,
      1.516504,
      NULL,
      0,
      3.448917,
      NULL,
      1,
      1.651190,
      3.588425,
      0,
      1.705473,
      1,
      0,
      0,
      2.799241,
      1.994525,
      0,
      0,
      NULL,
      0.501859,
      0,
      0,
      NULL,
      2,
      1.887592,
      NULL,
      NULL,
      0,
      0.273200,
      1,
      1.812418,
      NULL,
      1,
      1.795002,
      0,
      1.512587,
      NULL,
      NULL,
      NULL,
      1.612430,
      NULL,
      0.363448,
      1,
      0,
      0.993892,
      0,
      1.625841,
      0,
      0.172049,
      0,
      1,
      1.929156,
      1,
      1.650741,
      0.814357,
      NULL,
      0.048235,
      0,
      1.300816,
      0,
      1,
      1,
      1,
      0,
      0.608394,
      NULL,
      0.074621,
      1.071718,
      NULL,
      5,
      3.178448,
      '332',
      '002',
      NULL);
commit;
end;
/


