set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8922771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4301240',
      2.514331,
      0,
      NULL,
      3.745184,
      0.779147,
      NULL,
      NULL,
      86,
      NULL,
      3.841372,
      1,
      2.405258,
      0,
      0,
      0,
      2.771862,
      NULL,
      NULL,
      1,
      1.154804,
      0.734902,
      3,
      1,
      3.663011,
      1,
      0.285612,
      0,
      0.988755,
      NULL,
      3,
      0,
      1.688613,
      0,
      0.040402,
      0,
      NULL,
      1.588594,
      NULL,
      1.561877,
      0.702907,
      0.878046,
      0,
      NULL,
      0.129912,
      NULL,
      2.763104,
      0,
      2.054294,
      1,
      3.307684,
      1,
      0.969564,
      0,
      NULL,
      1.608302,
      0.499326,
      0,
      0,
      0.521603,
      3.916740,
      1,
      1.370083,
      0.388842,
      0.001940,
      1.989819,
      0.307874,
      0,
      3.625800,
      0,
      NULL,
      NULL,
      1,
      3,
      3.459516,
      0,
      1.670834,
      NULL,
      NULL,
      0.980714,
      0,
      0,
      1.425664,
      NULL,
      0.163382,
      NULL,
      0,
      0.443657,
      0,
      0.770471,
      1.684840,
      0.353619,
      2,
      NULL,
      0,
      1,
      NULL,
      1.446832,
      0.853257,
      3.261240,
      2.017370,
      3.648595,
      3,
      2,
      0,
      2,
      3,
      '',
      NULL,
      ' 9-12-1988');
commit;
end;
/


