set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8928592';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4110131',
      NULL,
      1,
      35.838868,
      0,
      2,
      4,
      22.041219,
      45,
      1.169534,
      1,
      1.841749,
      1.972872,
      0.296303,
      1.206630,
      NULL,
      1.536797,
      0,
      1,
      3,
      1.227034,
      1.225514,
      2.465898,
      1.226840,
      NULL,
      1.820984,
      1,
      NULL,
      2.058911,
      0.799056,
      0,
      NULL,
      NULL,
      NULL,
      1.480815,
      NULL,
      1,
      NULL,
      1.405459,
      1,
      NULL,
      3,
      1.087497,
      1,
      1,
      NULL,
      2.445999,
      3.930768,
      0,
      NULL,
      0,
      0.946308,
      NULL,
      NULL,
      NULL,
      0.349582,
      0.531936,
      1.391942,
      0.970221,
      1,
      NULL,
      NULL,
      NULL,
      0.886364,
      NULL,
      0.878487,
      2.993508,
      0.720489,
      0.092637,
      1.500703,
      NULL,
      NULL,
      0.647106,
      NULL,
      2,
      1.178741,
      1.353940,
      1.085199,
      0.813773,
      1.717798,
      0.724896,
      0.788339,
      0,
      0,
      NULL,
      1.940317,
      0,
      NULL,
      0,
      1.347630,
      1,
      0,
      NULL,
      NULL,
      0.244372,
      2.043508,
      1,
      3,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      5.932539,
      '',
      '',
      ' 4- 7-2002');
commit;
end;
/


