set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8528467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2131200',
      1.350509,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      7.158630,
      1,
      1.155176,
      1.720598,
      NULL,
      2,
      NULL,
      1.065965,
      1.017817,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.395320,
      0.662911,
      1.152533,
      NULL,
      0.886076,
      2.523859,
      1,
      1,
      1.623300,
      0.690836,
      1,
      0,
      0.059914,
      0.007327,
      0.163580,
      NULL,
      1.393541,
      NULL,
      1,
      2,
      NULL,
      0.718060,
      0.468073,
      1.925118,
      0,
      1.413736,
      0,
      NULL,
      0.524041,
      1,
      0,
      0,
      1,
      1.100124,
      NULL,
      NULL,
      NULL,
      0.743791,
      0.996783,
      1,
      0.542237,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268100,
      NULL,
      1.038977,
      0.111833,
      1.998424,
      0,
      NULL,
      NULL,
      1,
      2.124768,
      0,
      1,
      0.318814,
      NULL,
      0,
      1.580533,
      1.452058,
      2,
      1.177155,
      1,
      0,
      3.975098,
      NULL,
      1,
      0.297361,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.427794,
      0,
      0.726734,
      3,
      2,
      '',
      '',
      ' 3- 4-1980');
commit;
end;
/


