set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000135';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3422431',
      NULL,
      1,
      24.101467,
      3,
      3.398814,
      2,
      47.449116,
      NULL,
      0,
      1.049179,
      3,
      0.332935,
      0,
      1,
      1,
      3,
      2,
      1,
      0,
      0,
      1.484249,
      1,
      NULL,
      1,
      NULL,
      1.933763,
      0,
      0.797003,
      1,
      NULL,
      0.483994,
      NULL,
      0.693432,
      1,
      0.924561,
      1,
      1.565908,
      1,
      1.673120,
      1.376053,
      0,
      3,
      NULL,
      0.953568,
      1.635244,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.762498,
      1,
      1.062200,
      1.364338,
      0,
      1,
      3.794533,
      1,
      1,
      1.660365,
      NULL,
      0.793098,
      NULL,
      1,
      1.970289,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.176173,
      0.059957,
      0,
      0,
      0.487203,
      1,
      1.540432,
      0.123346,
      1,
      1.471647,
      0,
      0,
      1.527655,
      0,
      1,
      1,
      NULL,
      1.795232,
      0,
      0,
      1,
      1.965942,
      2.710747,
      0,
      3.040831,
      0,
      3.801258,
      NULL,
      1.262407,
      1,
      5,
      2,
      '',
      '',
      ' 3- 3-1976');
commit;
end;
/


