set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7407185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3133413',
      3,
      3,
      35,
      NULL,
      1.202593,
      3.000057,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.684286,
      1,
      1.021158,
      3.397051,
      NULL,
      0.964467,
      0,
      0.218233,
      0,
      NULL,
      1.732174,
      2.004882,
      0.776692,
      3.676305,
      0,
      1,
      1,
      0,
      1,
      1.348405,
      0.251465,
      1,
      NULL,
      2.326086,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      2.273819,
      2.905420,
      1,
      0.296897,
      NULL,
      0.689495,
      0,
      1.241288,
      NULL,
      1,
      NULL,
      2.813451,
      1.882728,
      0.262577,
      1,
      NULL,
      3.334644,
      0.438155,
      1,
      1,
      0.607990,
      NULL,
      1.862889,
      3.999840,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.884453,
      NULL,
      NULL,
      1.580633,
      0,
      NULL,
      0.107743,
      0.905499,
      1,
      0,
      NULL,
      1.991958,
      0,
      1,
      1,
      2,
      0.119850,
      3.820414,
      0.885512,
      2,
      0,
      2.038086,
      NULL,
      1.870080,
      0.046663,
      NULL,
      3.103059,
      1.126015,
      1.609850,
      6.852470,
      1.643432,
      '',
      '',
      ' 5-22-1989');
commit;
end;
/


