set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4334110',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      NULL,
      1.754060,
      3.295341,
      NULL,
      0,
      0.223218,
      0.739973,
      0.189490,
      0,
      0,
      1.306069,
      1,
      3,
      0,
      0.184089,
      1.663055,
      0.642945,
      0.755078,
      0,
      NULL,
      1.409372,
      0.934546,
      NULL,
      0.888528,
      1,
      0,
      NULL,
      1.308674,
      0.843228,
      0,
      NULL,
      NULL,
      2,
      2.309627,
      NULL,
      1.207856,
      0.160499,
      0.417889,
      1,
      1.566038,
      NULL,
      1.313210,
      1,
      1.180429,
      NULL,
      0.887867,
      0,
      0.753697,
      0.310737,
      2,
      1.337327,
      NULL,
      1.017915,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.099167,
      1.151070,
      1.650840,
      0.947905,
      0,
      0,
      NULL,
      3.712599,
      1.663733,
      2,
      1.269912,
      1,
      1,
      1,
      0.779323,
      1.048233,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1.536364,
      1.283520,
      1,
      0.369521,
      3,
      NULL,
      1.617282,
      NULL,
      3.895185,
      0,
      NULL,
      21,
      3,
      NULL,
      '441',
      ' 9-16-1997');
commit;
end;
/


