set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000160';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3040030',
      1.047759,
      0,
      35.348311,
      0.078380,
      3,
      0,
      21,
      54.384835,
      1.580470,
      3.670737,
      NULL,
      0.537242,
      1.804397,
      1,
      0.396545,
      2,
      1,
      1.689119,
      0.702805,
      0,
      NULL,
      2,
      NULL,
      0,
      1.333591,
      0,
      1.401123,
      NULL,
      0,
      1,
      0.176086,
      1.923860,
      1,
      NULL,
      NULL,
      0.319248,
      NULL,
      NULL,
      NULL,
      3.677863,
      2.493301,
      3,
      1,
      1,
      NULL,
      1,
      1,
      2.625999,
      1.142831,
      3.155029,
      1.083077,
      0.284088,
      0,
      1,
      1.394128,
      0.238371,
      0.461154,
      NULL,
      NULL,
      0.536479,
      0,
      0.038281,
      0.859633,
      1.518601,
      0.267658,
      2.711083,
      0.539229,
      NULL,
      1.755878,
      NULL,
      0.079343,
      0,
      NULL,
      1,
      0.138542,
      0.467282,
      NULL,
      1.611122,
      1.351534,
      NULL,
      NULL,
      1.225474,
      0,
      NULL,
      1.492258,
      1.679857,
      0,
      NULL,
      1.844679,
      1,
      0,
      3,
      2,
      0,
      1,
      1.474408,
      2,
      0,
      2.314325,
      NULL,
      NULL,
      3.440551,
      0.297375,
      1.330415,
      4.631709,
      3,
      '',
      NULL,
      NULL);
commit;
end;
/


