set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104231',
      3,
      NULL,
      9.889623,
      2,
      0,
      3,
      61.575501,
      35.579798,
      3,
      2.259127,
      0.285665,
      0,
      1,
      0.867403,
      NULL,
      0.456542,
      0,
      0,
      NULL,
      0.764825,
      1,
      0.237651,
      1,
      1,
      1.489293,
      0,
      0.528674,
      NULL,
      0,
      2,
      0,
      0.535899,
      1,
      NULL,
      1.035436,
      0,
      0.350071,
      NULL,
      1.151860,
      NULL,
      3,
      3.781061,
      0.980568,
      1,
      1.392296,
      2,
      0.922144,
      1,
      1.498746,
      0.703916,
      NULL,
      0.905770,
      1.316784,
      0.341938,
      0.814363,
      NULL,
      1,
      0.300146,
      1,
      3,
      0,
      NULL,
      0.645442,
      1.938562,
      NULL,
      0.057783,
      1,
      NULL,
      1,
      2.290367,
      NULL,
      1.444139,
      0,
      NULL,
      NULL,
      1.368338,
      0.053413,
      1,
      0,
      NULL,
      0,
      0.603462,
      1,
      0,
      1,
      2,
      0,
      0.056378,
      0,
      0,
      1.998002,
      1.491771,
      0.109208,
      NULL,
      NULL,
      1,
      1.169227,
      NULL,
      0.304029,
      0,
      0.410050,
      0.851428,
      NULL,
      0,
      17.101551,
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


