set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8805448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0400101',
      0.975993,
      1,
      11,
      3.129409,
      0,
      NULL,
      NULL,
      NULL,
      1.080112,
      0,
      NULL,
      1.376711,
      3,
      0.279122,
      3.864706,
      0.827069,
      1.114336,
      NULL,
      2,
      0.851195,
      1,
      0,
      1,
      NULL,
      1,
      1.775223,
      1,
      0.058945,
      0,
      3,
      1,
      1.871658,
      0,
      0.662285,
      0.329709,
      0.787293,
      1,
      0.430878,
      1,
      0.897344,
      NULL,
      3.218971,
      0.995682,
      NULL,
      0,
      1,
      1.724482,
      NULL,
      1.857084,
      3.258451,
      0,
      NULL,
      1.792053,
      NULL,
      0.193142,
      1,
      0,
      0,
      1,
      0.513059,
      1.818353,
      1.446475,
      0,
      0.980007,
      NULL,
      1,
      1,
      1.032212,
      0.289336,
      1.928820,
      1,
      0.073445,
      NULL,
      2,
      0.248408,
      1.408196,
      NULL,
      1.968941,
      0.139278,
      1,
      NULL,
      NULL,
      0.206108,
      1.085877,
      NULL,
      0.906091,
      1,
      0,
      NULL,
      0,
      0.130277,
      1,
      0.463043,
      0.209251,
      0.144404,
      1,
      1,
      NULL,
      3,
      0,
      2.737605,
      0,
      0,
      NULL,
      NULL,
      3,
      '',
      '',
      NULL);
commit;
end;
/


