set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0004140',
      2.135153,
      2,
      31,
      1,
      1.567532,
      NULL,
      NULL,
      53.139055,
      0,
      NULL,
      0,
      0.389095,
      2.936077,
      0,
      NULL,
      1.475671,
      1.995553,
      1.217259,
      0,
      0.909014,
      NULL,
      2.405695,
      0.246262,
      2.429059,
      0,
      0.423273,
      1,
      0.691909,
      0,
      2,
      1.858567,
      0,
      1,
      1.482496,
      0.960078,
      0.354763,
      1.595951,
      NULL,
      0.214619,
      2.048095,
      2.020980,
      0,
      1.579969,
      0.995389,
      NULL,
      NULL,
      1.435199,
      0.175617,
      1,
      0,
      1.480701,
      1.660020,
      0.702882,
      0.915154,
      1,
      1.327444,
      0.902277,
      1,
      NULL,
      NULL,
      0.776765,
      1.495835,
      NULL,
      0.553114,
      1.137941,
      2,
      1,
      NULL,
      1,
      1,
      0,
      1,
      2.382000,
      0.064303,
      0.612296,
      0.786967,
      1.668401,
      1.174665,
      0,
      1.099862,
      1,
      NULL,
      NULL,
      1.161138,
      0,
      0,
      0,
      1,
      NULL,
      0.385363,
      0,
      0.505059,
      0.101368,
      0.662895,
      2,
      0.142259,
      1.293870,
      NULL,
      1,
      1,
      2.444710,
      1,
      2.126880,
      1.764822,
      9.458801,
      2.538214,
      '',
      '',
      ' 5-13-1998');
commit;
end;
/


