set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9301596';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1230402',
      NULL,
      2,
      19,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.668358,
      1.212084,
      1.486485,
      NULL,
      1.911896,
      1,
      NULL,
      3,
      1,
      3,
      1,
      0,
      NULL,
      1.864503,
      1,
      0.147103,
      1.780457,
      NULL,
      1.860940,
      1,
      NULL,
      1.122947,
      0.994638,
      NULL,
      NULL,
      3.183160,
      NULL,
      3.397237,
      2,
      NULL,
      0.962949,
      3.499114,
      1.537444,
      1.442101,
      1,
      0.238363,
      NULL,
      1,
      0.129378,
      1.296249,
      1,
      0.505610,
      1,
      NULL,
      3.376586,
      1,
      1,
      1.270420,
      0.285302,
      1.362148,
      0.661248,
      1,
      NULL,
      3,
      1.744634,
      0.379847,
      NULL,
      1.581287,
      0,
      0,
      0,
      NULL,
      0.966536,
      0.158187,
      0.476443,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.197234,
      1.915057,
      1.277826,
      NULL,
      1,
      1,
      0.086528,
      0.522902,
      1.506798,
      1.878053,
      NULL,
      1.274693,
      0,
      1,
      2,
      3.415076,
      2,
      0.932852,
      1.000714,
      NULL,
      NULL,
      '114',
      '114',
      ' 8-15-1998');
commit;
end;
/


