set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000116';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      0,
      30,
      NULL,
      1.570214,
      1.786704,
      35,
      49.035519,
      1,
      NULL,
      0.385427,
      0.728418,
      0.490764,
      0,
      1.286852,
      0.595353,
      0,
      0,
      1,
      NULL,
      1,
      3.284493,
      1.597989,
      1.412630,
      0.168316,
      1,
      2,
      0.885097,
      1.029431,
      0,
      NULL,
      2,
      0.380375,
      NULL,
      1,
      NULL,
      1.033493,
      0,
      0,
      1.754053,
      0,
      0,
      0.508497,
      2,
      NULL,
      NULL,
      3,
      0,
      0.714852,
      0.326146,
      1,
      0,
      3,
      3.449697,
      0,
      0.762676,
      0.873700,
      0.567351,
      1.591171,
      3,
      0,
      1.339281,
      1.973418,
      1.629018,
      0,
      0,
      NULL,
      0,
      1.547615,
      1.011463,
      0.455325,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600284,
      0.665826,
      1,
      1.619122,
      3.012830,
      NULL,
      1.411025,
      0.169313,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.769191,
      0,
      0.484572,
      NULL,
      1.425488,
      0,
      0,
      1,
      NULL,
      2,
      0.143403,
      1.906781,
      3,
      1.748409,
      0.263939,
      18.723982,
      0.702332,
      '',
      '',
      ' 0-13-1995');
commit;
end;
/


