set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808017';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0412130',
      NULL,
      2,
      22.479111,
      2,
      0.104836,
      NULL,
      NULL,
      4.617256,
      1,
      2,
      1,
      0.374510,
      2.324395,
      1,
      NULL,
      NULL,
      1.456050,
      1,
      3.834835,
      1,
      1,
      NULL,
      0.665291,
      2.246582,
      0,
      1,
      1.088522,
      0.826045,
      1.883163,
      NULL,
      0.665353,
      1,
      0.573328,
      1.993186,
      0,
      2,
      0,
      0.904335,
      1.290087,
      3,
      NULL,
      0.573568,
      0.222888,
      NULL,
      0.027299,
      2.224583,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.170692,
      1.687904,
      0,
      NULL,
      0.031406,
      2.896125,
      3.113086,
      0,
      0,
      1,
      0,
      0.856465,
      2,
      0,
      1.692332,
      1.637008,
      1.845256,
      1.595830,
      1.368229,
      0,
      2,
      1.120223,
      NULL,
      0,
      0.828884,
      1.970673,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.238374,
      1.051336,
      0.945270,
      0.914398,
      1,
      0,
      2,
      3.441372,
      1.542075,
      0.232200,
      1,
      NULL,
      0,
      3.388951,
      2,
      1,
      NULL,
      3.088373,
      0.258605,
      0,
      7,
      '',
      '',
      ' 5-27-1993');
commit;
end;
/


