set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3642400';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421204',
      2,
      0,
      1,
      2.411649,
      3,
      5.158171,
      40,
      NULL,
      1,
      0.512274,
      NULL,
      1,
      3.786962,
      NULL,
      0.481179,
      NULL,
      NULL,
      0,
      1.779533,
      0.840201,
      0,
      1,
      NULL,
      0,
      0.866320,
      0.413363,
      0,
      1.832537,
      0.868461,
      1.525864,
      1,
      1.697074,
      0.258633,
      1,
      1.566039,
      1.417594,
      0,
      1,
      0,
      3,
      1.493716,
      0.505333,
      0,
      0.419086,
      0.254854,
      NULL,
      1.393155,
      0.206261,
      1.836073,
      3.221937,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      3.576033,
      0.491942,
      0,
      1,
      0,
      3.257807,
      0,
      0,
      1.210022,
      1.954034,
      1,
      1.271280,
      NULL,
      0.633074,
      NULL,
      3.457927,
      0.474399,
      2,
      0.418671,
      1,
      1.735627,
      0.702688,
      1,
      0.686752,
      0,
      0.960082,
      1.990835,
      1.266033,
      3,
      0,
      NULL,
      NULL,
      2.306016,
      1,
      1.509541,
      1,
      0.031248,
      0,
      NULL,
      1,
      2.075183,
      1.858762,
      3.342423,
      3,
      0,
      0,
      21.180600,
      2,
      '',
      '',
      ' 1- 9-1984');
commit;
end;
/


