set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8433669';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      0,
      10.177738,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.875952,
      NULL,
      NULL,
      1,
      0.760702,
      1,
      NULL,
      1.753112,
      1,
      1,
      0,
      1.111276,
      1.153292,
      NULL,
      1.243051,
      1,
      0,
      0.025144,
      0.347493,
      0,
      1,
      0.078908,
      NULL,
      NULL,
      1.619916,
      NULL,
      0.321596,
      NULL,
      1,
      3,
      1.341317,
      0.577559,
      0.001856,
      0.811650,
      1.686540,
      2.722999,
      0,
      0,
      1.116150,
      NULL,
      0.608620,
      0.322614,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.725196,
      0.983414,
      1.202606,
      0,
      0,
      0,
      1.258143,
      1,
      0.905206,
      NULL,
      1.629466,
      NULL,
      0,
      1.487671,
      2.113541,
      1,
      NULL,
      0.338568,
      1,
      1.499120,
      0.491737,
      0,
      NULL,
      1,
      0,
      1,
      0.919660,
      0,
      NULL,
      0.695804,
      0.207452,
      1,
      1.206342,
      NULL,
      1.483434,
      0,
      1.202676,
      1.101359,
      2.377192,
      0,
      1,
      0,
      3,
      NULL,
      1,
      1.252762,
      6.144783,
      1,
      '',
      '',
      NULL);
commit;
end;
/


