set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2024413',
      NULL,
      NULL,
      6.110099,
      0.678238,
      3,
      4.984076,
      15,
      7.758677,
      1,
      NULL,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.383197,
      2.818159,
      0.101234,
      0.414471,
      3,
      1.172668,
      1,
      0.616025,
      2.068407,
      0,
      2,
      1.843932,
      2,
      NULL,
      0,
      0,
      1.029967,
      0.791926,
      3.630454,
      1,
      1.971659,
      0,
      3.970739,
      1.076349,
      0.931364,
      1.766778,
      0.395128,
      NULL,
      NULL,
      0.497000,
      0,
      1,
      2.007119,
      NULL,
      NULL,
      0.850646,
      NULL,
      0,
      0.632190,
      0.612519,
      1.818992,
      2,
      0,
      1,
      0.852336,
      0,
      0,
      0.686333,
      3.328667,
      NULL,
      0.612307,
      0.411459,
      1,
      0.104999,
      1,
      1.948279,
      3.754089,
      1,
      3.796878,
      0.885827,
      0.418128,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.582038,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      2,
      0,
      0,
      NULL,
      0,
      1.520152,
      3.646060,
      1,
      2.950672,
      2,
      1.652366,
      0,
      11,
      3.435746,
      '',
      '',
      ' 2- 4-1997');
commit;
end;
/


