set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1243101',
      0.518796,
      3,
      28.348636,
      0,
      0,
      0,
      36.348587,
      34,
      0.970973,
      2.753007,
      1,
      1.510484,
      3,
      NULL,
      2.799175,
      2.036449,
      NULL,
      1,
      3.064332,
      0,
      0,
      2.019445,
      NULL,
      3,
      0,
      0.755317,
      3.596814,
      1,
      0,
      0.594118,
      NULL,
      0.349698,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      3.917422,
      2,
      1,
      0,
      3,
      2,
      NULL,
      0.437185,
      0,
      3,
      1.491883,
      2,
      1.365051,
      1.321144,
      0,
      0.842947,
      0.134213,
      0,
      1,
      1.838464,
      1.206610,
      3,
      1,
      0.317577,
      NULL,
      1.668468,
      1.263571,
      3.454637,
      1.370024,
      1.919997,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0.696300,
      0,
      0.398808,
      0.126124,
      0.000259,
      1.759278,
      1.527344,
      1.663480,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.174470,
      0.762461,
      0,
      NULL,
      NULL,
      1.593158,
      NULL,
      1.655230,
      1.579684,
      1.472257,
      0.231788,
      0,
      3,
      1.560871,
      1.149344,
      3.639211,
      8,
      '',
      '',
      '10-16-1981');
commit;
end;
/


