set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7126107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2223104',
      2.968204,
      NULL,
      6.742808,
      0,
      0.080071,
      NULL,
      NULL,
      8,
      1.652763,
      3.408864,
      NULL,
      3.468608,
      1,
      0,
      NULL,
      NULL,
      0,
      1.424926,
      NULL,
      1.355500,
      1.171625,
      NULL,
      1.868610,
      NULL,
      1,
      0.387957,
      0,
      NULL,
      1.763759,
      0.714590,
      NULL,
      1,
      NULL,
      1,
      1,
      3.628081,
      NULL,
      1.798884,
      0,
      NULL,
      0,
      3.042139,
      NULL,
      NULL,
      0,
      0.718329,
      0.772241,
      2.788330,
      NULL,
      1,
      0.650199,
      0,
      1,
      0,
      0.955605,
      NULL,
      1.154194,
      1.222563,
      1,
      3.948392,
      1,
      0.326578,
      0.983981,
      0,
      1,
      2,
      0,
      0.579685,
      1.289780,
      NULL,
      NULL,
      1.761915,
      1.201021,
      1.759285,
      1.230462,
      0.399686,
      3,
      0,
      1,
      0,
      1,
      0.797752,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.831700,
      NULL,
      1.943784,
      2.738602,
      NULL,
      0,
      0,
      0.907763,
      0,
      1.214431,
      2,
      0.524281,
      NULL,
      3.755045,
      1.225684,
      5,
      NULL,
      '',
      '',
      ' 1-10-2000');
commit;
end;
/


