set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8127344';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012402',
      3,
      3,
      19,
      1,
      0.750718,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      3.518181,
      2.910291,
      0,
      0.630364,
      3,
      1.543371,
      1.515824,
      0.019733,
      1.164494,
      1,
      NULL,
      0.262585,
      1.699725,
      1.610190,
      1.808129,
      1.629030,
      NULL,
      1.622778,
      3,
      NULL,
      0,
      NULL,
      1,
      0.345924,
      1,
      1,
      NULL,
      1.933341,
      3,
      1.949279,
      3,
      NULL,
      1.691032,
      NULL,
      1.363298,
      1.159225,
      2,
      0,
      0,
      0,
      1.251412,
      0.565157,
      NULL,
      0,
      NULL,
      0.387499,
      3,
      0,
      1.726250,
      0,
      1,
      0,
      1.574042,
      NULL,
      2,
      1.759612,
      NULL,
      1.597037,
      1,
      NULL,
      1,
      1.263904,
      NULL,
      1.147273,
      2.917968,
      0.809681,
      0.092902,
      1.265963,
      1,
      0.035657,
      1,
      0,
      0,
      0,
      2,
      0,
      1.472231,
      1,
      1,
      1.450245,
      0,
      3,
      1,
      NULL,
      0.711840,
      0.921469,
      0.048880,
      0,
      0,
      0.332623,
      0.374934,
      0,
      0,
      3,
      2,
      '',
      NULL,
      ' 3-20-1996');
commit;
end;
/


