set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8135230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0003100',
      NULL,
      NULL,
      14.124438,
      NULL,
      2.681925,
      2.381741,
      5,
      57,
      1,
      0,
      NULL,
      2.535987,
      1.412630,
      0,
      3.579484,
      3.220783,
      NULL,
      1.997905,
      NULL,
      NULL,
      NULL,
      2.418788,
      0.855476,
      NULL,
      0,
      1,
      NULL,
      0.069368,
      NULL,
      2.393500,
      0.054377,
      NULL,
      1.370333,
      0.862679,
      1,
      0,
      0,
      0,
      1,
      1.419717,
      3,
      3.622328,
      2.588379,
      2,
      NULL,
      0.964575,
      1.552945,
      NULL,
      1.020612,
      1.541386,
      0,
      0,
      0.338960,
      0,
      0,
      0.373026,
      0,
      NULL,
      0.963461,
      2,
      1,
      0.308012,
      1.987555,
      0.341195,
      0,
      3.591244,
      1.157029,
      3.472695,
      0,
      1,
      1.270294,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.102431,
      NULL,
      1.808845,
      0,
      1,
      0,
      1,
      1,
      1,
      1.801145,
      3,
      0.986667,
      0.257262,
      0.630738,
      0,
      NULL,
      1.093832,
      3.878113,
      NULL,
      0,
      0.987704,
      2,
      3,
      0.927691,
      0,
      0.738678,
      0,
      12.706598,
      NULL,
      '',
      '',
      ' 0- 4-1983');
commit;
end;
/


