set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7205942';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1301400',
      0,
      0,
      13.920584,
      NULL,
      1.560281,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.844716,
      3,
      0.448715,
      3,
      3,
      1.580792,
      0.533657,
      3.121067,
      0,
      1.122136,
      0,
      0,
      1.869424,
      0.099781,
      2,
      1,
      1,
      0,
      0.533798,
      NULL,
      0.689001,
      0.987902,
      0,
      NULL,
      0,
      0,
      1,
      1.520205,
      NULL,
      2,
      NULL,
      0.062895,
      3,
      0.419846,
      2,
      2.652982,
      NULL,
      0,
      2.558920,
      0.114525,
      0.755242,
      1,
      0.342071,
      NULL,
      0.272896,
      0.156002,
      0,
      2,
      3.943204,
      0.911923,
      1.745598,
      1.334778,
      0.356876,
      1.397111,
      2.086333,
      0.390624,
      NULL,
      1,
      0,
      0.233383,
      1,
      2,
      NULL,
      0.523406,
      0,
      0,
      1.405245,
      0.026069,
      1,
      2.034463,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.350515,
      NULL,
      0.748255,
      NULL,
      NULL,
      NULL,
      1.017457,
      0,
      0.387646,
      2.138526,
      1,
      0,
      3,
      2,
      0,
      3,
      0,
      NULL,
      2,
      '214',
      '044',
      NULL);
commit;
end;
/


