set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1131132',
      3,
      0,
      10.111869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175702,
      2.363050,
      3.220461,
      NULL,
      1.570714,
      NULL,
      0.410907,
      NULL,
      NULL,
      1.500062,
      2.609359,
      1.698961,
      1,
      0,
      0.975656,
      3.881447,
      1.314817,
      NULL,
      1.649823,
      3.609003,
      1,
      0.998471,
      0,
      0.065286,
      0,
      NULL,
      1.361383,
      1,
      NULL,
      0.811883,
      0,
      3,
      0,
      3.716618,
      3,
      1,
      NULL,
      NULL,
      1.337913,
      NULL,
      1.709714,
      NULL,
      1.662202,
      0,
      1.457088,
      NULL,
      1,
      1,
      1.795555,
      0.278963,
      2,
      NULL,
      0.501356,
      1,
      0.986021,
      1.431318,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      0.076998,
      1.527872,
      1.639489,
      0.737594,
      1,
      0.786045,
      0.671853,
      0.200763,
      1,
      0.771086,
      1,
      NULL,
      NULL,
      0,
      0.508113,
      1.910133,
      1,
      1.140871,
      NULL,
      NULL,
      1.523883,
      NULL,
      NULL,
      1.729498,
      1.271450,
      0,
      1.849012,
      2.607743,
      3.222231,
      NULL,
      5,
      1,
      '313',
      '41',
      ' 8-25-1979');
commit;
end;
/


