set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3031244',
      2,
      2,
      24,
      2,
      1,
      NULL,
      3.080412,
      1.829308,
      NULL,
      NULL,
      0,
      2.573708,
      0.252241,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      3.789727,
      0.186115,
      NULL,
      1,
      3.427255,
      NULL,
      NULL,
      NULL,
      1.197809,
      1,
      3.836266,
      1,
      3,
      0,
      0,
      NULL,
      3.870629,
      NULL,
      NULL,
      1,
      3.164064,
      NULL,
      1,
      2,
      3.823368,
      0.614529,
      NULL,
      NULL,
      3,
      0.963595,
      3.700000,
      0.544698,
      0,
      1,
      0.330980,
      0.129716,
      0.055071,
      1,
      0.295487,
      NULL,
      3,
      0.719143,
      0.652070,
      1,
      1,
      NULL,
      1.779991,
      0,
      3,
      0.058910,
      1.993582,
      0,
      1,
      2,
      3,
      0.764347,
      0.981616,
      1,
      1.351668,
      1.746716,
      0,
      3,
      0,
      1,
      1.751514,
      NULL,
      0.527608,
      0.210551,
      0.291265,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.727885,
      0.886657,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.796977,
      1.028873,
      2.283632,
      7.085468,
      '111',
      '213',
      '10-12-1977');
commit;
end;
/


