set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8236807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3321013',
      NULL,
      NULL,
      23,
      2.330874,
      0.776708,
      NULL,
      NULL,
      52,
      0.184765,
      NULL,
      1.087587,
      3,
      2,
      1.112664,
      2.876044,
      NULL,
      0,
      NULL,
      0.870505,
      1,
      0.530553,
      0.274846,
      NULL,
      NULL,
      0.457171,
      2.412539,
      0.480865,
      NULL,
      1.622328,
      0,
      1.252843,
      0,
      1.685630,
      1,
      1.560233,
      3.665030,
      0,
      0,
      1.225111,
      0,
      1.128730,
      NULL,
      1.412435,
      3.562026,
      1,
      0.093352,
      0.786379,
      3.433328,
      0,
      0.859696,
      1.352602,
      1,
      1,
      0,
      1.311593,
      0,
      0,
      0.821960,
      1.005580,
      0,
      NULL,
      0.541185,
      1,
      0,
      0,
      2,
      NULL,
      0.838321,
      0,
      0,
      0,
      1.405216,
      0,
      1,
      1.624030,
      0.656126,
      1.551597,
      0,
      0.765791,
      0,
      0,
      NULL,
      1,
      0,
      1.921702,
      1.421980,
      3,
      1.943349,
      0.470440,
      0,
      0.572528,
      1.211583,
      NULL,
      NULL,
      0.817380,
      0,
      2,
      1,
      NULL,
      3.698256,
      NULL,
      NULL,
      2,
      0.526017,
      NULL,
      2.482892,
      NULL,
      '',
      ' 3-28-1989');
commit;
end;
/


