set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9221530';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4124001',
      0.861306,
      0,
      NULL,
      2.527969,
      1.123982,
      NULL,
      NULL,
      21.307481,
      1,
      3.030728,
      1,
      1,
      3.638900,
      0,
      NULL,
      3.013853,
      1.162775,
      NULL,
      1.633502,
      0.481043,
      NULL,
      NULL,
      0,
      3.161723,
      0.231136,
      0,
      0.083043,
      1.137312,
      0,
      1,
      0.580982,
      1.381669,
      1,
      NULL,
      0,
      2,
      1.852191,
      1,
      1,
      3,
      NULL,
      0.261591,
      1,
      0.575106,
      1.818957,
      1.714539,
      1,
      1,
      0,
      2,
      NULL,
      0.638630,
      1.830128,
      NULL,
      0,
      NULL,
      1.250271,
      0.928779,
      NULL,
      NULL,
      NULL,
      0.913531,
      0,
      NULL,
      1,
      2.469538,
      1.859168,
      2.943480,
      1,
      0.190332,
      1.958996,
      NULL,
      NULL,
      3,
      1.233890,
      1.132219,
      1,
      NULL,
      1.828905,
      0.682831,
      1.859765,
      NULL,
      1,
      0.322048,
      1,
      1,
      1.676153,
      0,
      1.350721,
      NULL,
      0.853494,
      3,
      1.433690,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      2.553576,
      1,
      2,
      1.013548,
      0,
      2.006866,
      '402',
      '000',
      ' 1- 0-1978');
commit;
end;
/


