set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8803426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4133100',
      3.632775,
      2,
      26.574310,
      3.059969,
      1.791955,
      NULL,
      NULL,
      2.942082,
      NULL,
      0,
      0.314067,
      NULL,
      3,
      0,
      1,
      NULL,
      1.245136,
      NULL,
      NULL,
      1.891879,
      0.393321,
      0,
      0.693231,
      NULL,
      NULL,
      2.085090,
      1,
      0.978524,
      1.084139,
      0.767506,
      0.100947,
      0,
      0.700312,
      0.981442,
      0,
      1,
      0.496784,
      1.314634,
      0,
      3,
      2,
      3.953283,
      2.367862,
      3,
      0,
      2.462102,
      NULL,
      1,
      0.895261,
      NULL,
      1.047746,
      1.876765,
      0,
      0.807142,
      0,
      1,
      0.482130,
      NULL,
      0.540641,
      1,
      NULL,
      1,
      0,
      0.645749,
      0,
      3.687458,
      NULL,
      0,
      0,
      0.766248,
      NULL,
      NULL,
      0.582433,
      0.119698,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.572783,
      0,
      1,
      NULL,
      2.519946,
      0.239982,
      0.573119,
      1,
      1,
      NULL,
      3,
      NULL,
      0.585598,
      0.274753,
      1,
      3.179571,
      0,
      1.648796,
      NULL,
      1.929938,
      0,
      0,
      1.302183,
      4.250654,
      3,
      '',
      '',
      '10- 4-1989');
commit;
end;
/


