set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1222120',
      2.044583,
      1,
      33,
      2,
      0.491531,
      NULL,
      NULL,
      58.129528,
      1.724841,
      0,
      NULL,
      1,
      0.216020,
      1.022996,
      0,
      2,
      NULL,
      1.351207,
      NULL,
      1.807749,
      NULL,
      3.886384,
      1.476907,
      3,
      1,
      NULL,
      1.121017,
      NULL,
      0.848276,
      1.928458,
      0,
      0.217106,
      1.533676,
      0,
      0.250745,
      1,
      1.677506,
      NULL,
      1,
      2,
      3,
      1.116162,
      3.510251,
      1.574059,
      0,
      3,
      1.713492,
      0,
      1,
      0,
      0.975410,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0.655905,
      0,
      3,
      0,
      1.686572,
      NULL,
      0.001994,
      0,
      2.084324,
      1.465978,
      NULL,
      0.616042,
      2,
      0.879585,
      NULL,
      2.496207,
      0.219594,
      1,
      0.062931,
      0,
      0.686965,
      1.776019,
      0,
      1.427602,
      1.033327,
      1.974937,
      0,
      1,
      0,
      0,
      0,
      0,
      0.534038,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.481753,
      1.874063,
      1,
      NULL,
      2.908965,
      2.127909,
      1.096506,
      3,
      3,
      NULL,
      NULL,
      '12',
      NULL);
commit;
end;
/


