set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7038100';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.429102,
      3,
      8,
      2,
      2.709872,
      2.483041,
      31,
      8.278173,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1.704516,
      0.721057,
      0.553019,
      NULL,
      0.769634,
      NULL,
      2,
      1,
      NULL,
      0,
      2,
      0.935991,
      NULL,
      0,
      0.749565,
      NULL,
      1.029763,
      0,
      NULL,
      NULL,
      3.567300,
      0,
      0,
      0.060552,
      2,
      0,
      0,
      1.577156,
      0.609981,
      1.022719,
      0,
      0.691234,
      0,
      1,
      0,
      1.051027,
      0,
      1,
      0,
      0,
      0,
      3,
      0.979724,
      3.773976,
      2,
      1,
      0.598739,
      0.492032,
      0,
      1.374390,
      1,
      1.325303,
      2.663029,
      1,
      0.375110,
      1.996175,
      0.503790,
      3,
      2.890190,
      1.480450,
      0,
      0.089903,
      NULL,
      1.095150,
      1,
      1.823162,
      1.020182,
      1.012375,
      1,
      1.864191,
      NULL,
      1.396555,
      0,
      1,
      1,
      0.095777,
      0.575482,
      0,
      NULL,
      1.365047,
      0.077723,
      0.995648,
      1,
      2,
      0,
      1,
      NULL,
      0.528815,
      1.422788,
      NULL,
      0,
      NULL,
      NULL,
      NULL);
commit;
end;
/


