set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000194';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3041114',
      2.928254,
      0,
      NULL,
      2,
      0,
      5.618891,
      4.405207,
      79.542208,
      1.577624,
      0.368889,
      2,
      1.180177,
      0,
      0.222957,
      2,
      2.346913,
      1.345103,
      1.587001,
      3.489256,
      2.277112,
      1.329868,
      3,
      1.795625,
      NULL,
      0.890288,
      NULL,
      NULL,
      2.141919,
      0,
      3.293050,
      NULL,
      NULL,
      0.290071,
      2.451171,
      0.769413,
      3.221598,
      NULL,
      1,
      0.622456,
      2.670586,
      3.735291,
      2.267028,
      3,
      2,
      1.466198,
      0.833676,
      0.282714,
      0.320461,
      NULL,
      2,
      0.734388,
      0.148275,
      0.956841,
      0,
      NULL,
      NULL,
      1,
      1.062750,
      NULL,
      0.655751,
      NULL,
      1.960826,
      NULL,
      1.840506,
      1,
      2.157221,
      0.032451,
      2,
      0,
      1.536431,
      0.716342,
      NULL,
      0,
      0.002360,
      0.651345,
      1.027260,
      0.936431,
      3.677189,
      0.089926,
      0.629349,
      NULL,
      1.258709,
      NULL,
      1,
      0,
      0,
      0,
      0.116562,
      1.605119,
      NULL,
      1.427135,
      1.443754,
      0,
      1.307478,
      0.129968,
      1.386866,
      NULL,
      1.399152,
      1.114410,
      3.276301,
      3,
      NULL,
      NULL,
      1,
      19,
      0.247743,
      NULL,
      NULL,
      ' 4- 8-1980');
commit;
end;
/


