set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3355607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0310111',
      2.061109,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      89,
      0,
      3.641258,
      NULL,
      0.071611,
      0.380049,
      NULL,
      3.896955,
      NULL,
      0.203256,
      1.845521,
      NULL,
      2.722776,
      3.398637,
      0.044182,
      NULL,
      3.301994,
      1,
      0.462585,
      1,
      1,
      NULL,
      2.421966,
      NULL,
      NULL,
      2.424000,
      NULL,
      NULL,
      NULL,
      0,
      1.792661,
      0.588747,
      1.519707,
      3.637574,
      NULL,
      NULL,
      1.622024,
      1,
      0.384506,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0.116249,
      NULL,
      NULL,
      0.070420,
      NULL,
      NULL,
      0.489685,
      1,
      0.778427,
      1,
      NULL,
      0,
      0,
      1.021198,
      0,
      NULL,
      0.941007,
      1.201041,
      2.465348,
      0.729595,
      2,
      2.241340,
      1,
      3.446512,
      NULL,
      3.895413,
      1,
      0,
      0.738675,
      0,
      1,
      1.560184,
      0,
      NULL,
      0,
      NULL,
      1,
      0.880986,
      0,
      0.167834,
      NULL,
      0.011381,
      1.795100,
      NULL,
      NULL,
      1,
      2.479222,
      0,
      3,
      1,
      1,
      0,
      3.274053,
      6.453479,
      '',
      '',
      ' 3- 2-1986');
commit;
end;
/


