set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9301594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      22.533772,
      NULL,
      0,
      NULL,
      NULL,
      36,
      1.106661,
      NULL,
      NULL,
      2.871601,
      3.467090,
      NULL,
      0.477867,
      NULL,
      1,
      0.354881,
      3,
      0,
      1.530500,
      1.067132,
      1,
      NULL,
      0.147727,
      0.358205,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0.249867,
      0.553784,
      0.305796,
      0.349186,
      2,
      3.512367,
      1.272390,
      2.938936,
      NULL,
      3,
      1.563055,
      2,
      0,
      3,
      0,
      1,
      NULL,
      0,
      0.059431,
      0.093289,
      0,
      NULL,
      NULL,
      1,
      0,
      1.485563,
      0.113476,
      0,
      1,
      1,
      1.909149,
      0.241870,
      0.541749,
      1.935382,
      1.383680,
      0,
      1.678985,
      1.354965,
      1,
      1.664913,
      1,
      0.632147,
      0,
      NULL,
      1,
      0.318194,
      0,
      0,
      1.028840,
      0,
      0.454049,
      1,
      NULL,
      NULL,
      0.224636,
      0,
      NULL,
      0.489427,
      1.828865,
      0,
      NULL,
      1.109032,
      2.185871,
      1.713829,
      0.301289,
      NULL,
      1.875637,
      0.935483,
      5,
      0.334646,
      '212',
      '210',
      ' 2- 1-1978');
commit;
end;
/


