set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7519100';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2120343',
      3.604513,
      NULL,
      1.665274,
      NULL,
      3.449853,
      2,
      NULL,
      23,
      1.861260,
      0.719815,
      1,
      1.013858,
      3,
      1,
      0,
      0.325380,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.529570,
      0,
      0,
      NULL,
      1.312739,
      1.079281,
      0,
      1.456650,
      NULL,
      0.880610,
      NULL,
      1.400743,
      NULL,
      NULL,
      3.158002,
      NULL,
      0.948686,
      1.430051,
      NULL,
      1.920601,
      1,
      NULL,
      1.364648,
      NULL,
      2,
      0.704033,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.407544,
      2,
      0.829749,
      0,
      1,
      0,
      2.734788,
      NULL,
      1.926133,
      NULL,
      1,
      0,
      3.174567,
      1.956615,
      1.781649,
      2,
      0,
      NULL,
      0.818150,
      0.154803,
      1.090669,
      1.358279,
      1,
      1,
      1,
      NULL,
      1.900884,
      1.479193,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.863084,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1.169306,
      1,
      0.083273,
      1.659351,
      2.910394,
      5.753261,
      NULL,
      '',
      '',
      ' 7-12-1975');
commit;
end;
/


