set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000233';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2131224',
      NULL,
      0,
      5.775559,
      3.440513,
      0,
      3.332471,
      NULL,
      65,
      0.179974,
      0,
      2.298906,
      3.471135,
      NULL,
      0,
      0.079080,
      NULL,
      0,
      NULL,
      1.575463,
      NULL,
      1.250550,
      2,
      0.892265,
      0,
      1.726530,
      NULL,
      0,
      1,
      NULL,
      3,
      1.777704,
      0.597942,
      NULL,
      0,
      1.276848,
      NULL,
      NULL,
      0.531536,
      0,
      0.068967,
      0.810332,
      2,
      NULL,
      0.010772,
      1.299832,
      NULL,
      0,
      2.502855,
      1.561662,
      2,
      1,
      0.219141,
      NULL,
      0.105684,
      0,
      0.977071,
      1.281252,
      NULL,
      NULL,
      2.410423,
      0,
      0,
      1.017879,
      0.328003,
      0.587839,
      0.897978,
      NULL,
      NULL,
      0.345199,
      0.944395,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      0,
      0.116051,
      1,
      1,
      0.290514,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.067017,
      0.776482,
      1.840528,
      0.904518,
      1.605606,
      NULL,
      3.359860,
      3,
      3.389550,
      3.768909,
      NULL,
      NULL,
      14.012625,
      NULL,
      '112',
      '043',
      ' 8-16-2003');
commit;
end;
/


